﻿© Fluke Calibration. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI DC Power Init LIB
INSTRUMENT:            Sub NI DC Power Setup LIB
INSTRUMENT:            Sub NI DC Power Output Off LIB
INSTRUMENT:            Sub NI DC Power Close LIB
DATE:                  2011-10-19 08:01:21
AUTHOR:                Fluke
REVISION:              $Revision: 1.2 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       248
=============================================================================
#
#  Text Source:
#    $RCSfile: sub_ni_dc_pwr_utils_lib.txt,v $
#    $Date: 2011/10/19 15:01:56 $
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        NI DC Power Class of instruments
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INIT                         PSUBI("Init")
  1.002  JMPL         SETUP                        PSUBI("Setup")
  1.003  JMPL         OUTPUT_OFF                   PSUBI("Output Off")
  1.004  JMPL         CLOSE                        PSUBI("Close")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment test number

# =====  Sub NI DC Power Init LIB  ==========================================

  2.001  LABEL        INIT
  2.002  MATH         @Method = "NI DC Power Init"

  2.003  DO
  2.004  MATH         MEM2 = @ModelNum
  2.005  MEM2         Open NI Measurement & Automation Explorer and determine
  2.005  MEM2         the resource name of the UUT.
  2.005  MEM2
  2.005  MEM2         The resource name is the string to the right of [MEM2]
  2.005  MEM2         in the tree view, under "Devices and Interfaces".
  2.005  MEM2
  2.005  MEM2         Enter UUT resource name (Ex. PXI1Slot2).
  2.006  MATH         ResourceName = MEM2
  2.007  LIB          DLL uut = "nidcpower_32.dll";
  2.008  LIB          @Status = uut.niDCPower_init
  2.008  LIB          (ResourceName, @viFalse, @viTrue, @vi);

  2.009  IF           @Status
  2.010  CALL         Sub NI DC Power Error Message LIB
  2.011  ENDIF

  2.012  UNTIL        (@Status == 0) || @Abort

  2.013  END

  2.014  EVAL   Increment test number

# =====  Sub NI DC Power Setup LIB  =========================================

  3.001  LABEL        SETUP
  3.002  MATH         @Method = "NI DC Power Abort"

  3.003  DO
  3.004  LIB          @Status = uut.niDCPower_Abort(@vi);

  3.005  IF           @Status
  3.006  CALL         Sub NI DC Power Error Message LIB
  3.007  ENDIF

  3.008  UNTIL        (@Status == 0)

  3.009  MATH         @Method = "NI DC Power Configure Output Function"

  3.010  DO
  3.011  LIB          @Status = uut.niDCPower_ConfigureOutputFunction
  3.011  LIB          (@vi, @niDCPwrChan, @niDCPwrFunc);

  3.012  IF           @Status
  3.013  CALL         Sub NI DC Power Error Message LIB
  3.014  ENDIF

  3.015  UNTIL        (@Status == 0)

  3.016  MATH         @Method = "NI DC Power Configure Voltage Level Range"

  3.017  DO
  3.018  LIB          @Status = uut.niDCPower_ConfigureVoltageLevelRange
  3.018  LIB          (@vi, @niDCPwrChan, @niDCPwrVoltLvlRng);

  3.019  IF           @Status
  3.020  CALL         Sub NI DC Power Error Message LIB
  3.021  ENDIF

  3.022  UNTIL        (@Status == 0)

  3.023  MATH         @Method = "NI DC Power Configure Voltage Level"

  3.024  DO
  3.025  LIB          @Status = uut.niDCPower_ConfigureVoltageLevel
  3.025  LIB          (@vi, @niDCPwrChan, @niDCPwrVolt);

  3.026  IF           @Status
  3.027  CALL         Sub NI DC Power Error Message LIB
  3.028  ENDIF

  3.029  UNTIL        (@Status == 0)

  3.030  MATH         @Method = "NI DC Power Configure Current Limit Range"

  3.031  DO
  3.032  LIB          @Status = uut.niDCPower_ConfigureCurrentLimitRange
  3.032  LIB          (@vi, @niDCPwrChan, @niDCPwrCurrLmtRng);

  3.033  IF           @Status
  3.034  CALL         Sub NI DC Power Error Message LIB
  3.035  ENDIF

  3.036  UNTIL        (@Status == 0)

  3.037  MATH         @Method = "NI DC Power Configure Current Limit"

  3.038  DO
  3.039  LIB          @Status = uut.niDCPower_ConfigureCurrentLimit
  3.039  LIB          (@vi, @niDCPwrChan, @niDCPwrValCurrRegulate,
  3.039  LIB          @niDCPwrCurrLmt);

  3.040  IF           @Status
  3.041  CALL         Sub NI DC Power Error Message LIB
  3.042  ENDIF

  3.043  UNTIL        (@Status == 0)

  3.044  MATH         @Method = "NI DC Power Configure Output Enable"

  3.045  DO
  3.046  LIB          @Status = uut.niDCPower_ConfigureOutputEnabled
  3.046  LIB          (@vi, @niDCPwrChan, @viTrue);

  3.047  IF           @Status
  3.048  CALL         Sub NI DC Power Error Message LIB
  3.049  ENDIF

  3.050  UNTIL        (@Status == 0)

  3.051  MATH         @Method = "NI DC Power Initiate"

  3.052  DO
  3.053  LIB          @Status = uut.niDCPower_Initiate(@vi);

  3.054  IF           @Status
  3.055  CALL         Sub NI DC Power Error Message LIB
  3.056  ENDIF

  3.057  UNTIL        (@Status == 0)

  3.058  END

  3.059  EVAL   Increment test number

# =====  Sub NI DC Power Output Off LIB  ====================================

  4.001  LABEL        OUTPUT_OFF
  4.002  MATH         @Method = "NI DC Power Abort"

  4.003  DO
  4.004  LIB          @Status = uut.niDCPower_Abort(@vi);

  4.005  IF           @Status
  4.006  CALL         Sub NI DC Power Error Message LIB
  4.007  ENDIF

  4.008  UNTIL        (@Status == 0)

  4.009  MATH         @Method = "NI DC Power Configure Output Enabled"

  4.010  DO
  4.011  LIB          @Status = uut.niDCPower_ConfigureOutputEnabled
  4.011  LIB          (@vi, @niDCPwrChan, @viFalse);

  4.012  IF           @Status
  4.013  CALL         Sub NI DC Power Error Message LIB
  4.014  ENDIF

  4.015  UNTIL        (@Status == 0)

  4.016  MATH         @Method = "NI DC Power Configure Voltage Level"

  4.017  DO
  4.018  LIB          @Status = uut.niDCPower_ConfigureVoltageLevel
  4.018  LIB          (@vi, @niDCPwrChan, 0);

  4.019  IF           @Status
  4.020  CALL         Sub NI DC Power Error Message LIB
  4.021  ENDIF

  4.022  UNTIL        (@Status == 0)

  4.023  MATH         @Method = "NI DC Power Initiate"

  4.024  DO
  4.025  LIB          @Status = uut.niDCPower_Initiate(@vi);

  4.026  IF           @Status
  4.027  CALL         Sub NI DC Power Error Message LIB
  4.028  ENDIF

  4.029  UNTIL        (@Status == 0)

  4.030  END

  4.031  EVAL   Increment test number

# =====  Sub NI DC Power Close LIB  =========================================

  5.001  LABEL        CLOSE
  5.002  MATH         @Method = "NI DC Power Close"

  5.003  DO
  5.004  LIB          @Status = uut.niDCPower_close(@vi);

  5.005  IF           @Status
  5.006  CALL         Sub NI DC Power Error Message LIB
  5.007  ENDIF

  5.008  UNTIL        (@Status == 0)

  5.009  END